/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.EnemyControl;
import control.GameControl;
import control.SoundControl;
import data.ColorArrangement;
import data.Constants;
import data.Debugging;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Random;
import model.EnemyModel;
import model.PlayerModel;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.util.BufferedImageUtil;

public class StaticDrawer {
    private static float[] fRedArray = new float[]{1.0f, 0.0f, 0.0f};
    private static float[] fYellowArray = new float[]{0.0f, 1.0f, 0.0f};
    private static float[] fBlueArray = new float[]{0.0f, 0.0f, 1.0f};
    private static float[] fColorArray = new float[3];
    public static float[][] distance = new float[Constants.VIEW_WIDTH * 2][Constants.VIEW_HEIGHT * 2];
    private static Random rand = new Random(5L);
    public static Texture texture = null;

    public static float[] getColorValues(float fBandNum, float k, boolean bUseBrokenColors) {
        float fRedVal = 0.0f;
        float fGreenVal = 0.0f;
        float fBlueVal = 0.0f;
        float fPercentInColorSpectrum = fBandNum / 120.0f;
        float fLow = 0.0f;
        float fMid = 0.0f;
        float fHigh = 0.0f;
        if ((fPercentInColorSpectrum += Debugging.fEnemyColorOffset) < 0.0f) {
            fPercentInColorSpectrum %= 1.0f;
        }
        if (fPercentInColorSpectrum < 0.33f) {
            fMid = fPercentInColorSpectrum / 0.33f;
            fLow = (0.33f - fPercentInColorSpectrum) / 0.33f;
        } else if (fPercentInColorSpectrum < 0.66f) {
            if (bUseBrokenColors) {
                fMid = (fPercentInColorSpectrum - 0.33f) / 0.33f;
                fHigh = (0.66f - fPercentInColorSpectrum) / 0.33f;
            } else {
                fHigh = (fPercentInColorSpectrum - 0.33f) / 0.33f;
                fMid = (0.66f - fPercentInColorSpectrum) / 0.33f;
            }
        } else if (bUseBrokenColors) {
            fHigh = (fPercentInColorSpectrum - 0.66f) / 0.33f;
            fLow = (1.0f - fPercentInColorSpectrum) / 0.33f;
        } else {
            fLow = (fPercentInColorSpectrum - 0.66f) / 0.33f;
            fHigh = (1.0f - fPercentInColorSpectrum) / 0.33f;
        }
        int i = 0;
        while (i < 3) {
            float fArrayValue = fHigh * fRedArray[i] + fMid * fYellowArray[i] + fLow * fBlueArray[i];
            if (i == 0) {
                fRedVal = fArrayValue;
            } else if (i == 1) {
                fGreenVal = fArrayValue;
            } else {
                fBlueVal = fArrayValue;
            }
            ++i;
        }
        fColorArray = new float[3];
        float grayscale = (fRedVal + fGreenVal + fBlueVal) / 3.0f;
        StaticDrawer.fColorArray[0] = fRedVal * k + grayscale * (1.0f - k);
        StaticDrawer.fColorArray[1] = fGreenVal * k + grayscale * (1.0f - k);
        StaticDrawer.fColorArray[2] = fBlueVal * k + grayscale * (1.0f - k);
        return fColorArray;
    }

    public static void initializeDistances() {
        int i = 0;
        while (i < Constants.VIEW_WIDTH * 2) {
            int j = 0;
            while (j < Constants.VIEW_HEIGHT * 2) {
                StaticDrawer.distance[i][j] = (float)Math.sqrt(i * i + j * j);
                ++j;
            }
            ++i;
        }
    }

    public static void drawStatic(float w, float h) {
        GL11.glEnable(3042);
        GL11.glBlendFunc(774, 770);
        GL11.glPointSize(2.0f);
        GL11.glBegin(0);
        int duplicate = 4;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.1f);
        int i = 0;
        while ((float)i < w / (float)duplicate) {
            int j = 0;
            while ((float)j < h / (float)duplicate) {
                if ((double)rand.nextFloat() > 0.4) {
                    int x = 0;
                    while (x < duplicate) {
                        int y = 0;
                        while (y < duplicate) {
                            GL11.glVertex2f((float)i + (float)x * w / (float)duplicate, (float)j + (float)y * h / (float)duplicate);
                            ++y;
                        }
                        ++x;
                    }
                }
                j += 2;
            }
            i += 2;
        }
        GL11.glEnd();
        GL11.glPointSize(1.0f);
        GL11.glDisable(3042);
    }

    public static void initializeTextures() {
        int iImageWidth = 128;
        int iImageHeight = 128;
        BufferedImage circleImage = new BufferedImage(iImageWidth, iImageHeight, 2);
        float radius = 64.0f;
        int i = 0;
        while (i < circleImage.getWidth()) {
            int j = 0;
            while (j < circleImage.getHeight()) {
                float distToCenter = distance[Math.abs(64 - i)][Math.abs(64 - j)];
                float fAlphaMultiplier = Math.abs(1.0f - distToCenter / radius);
                if (distToCenter > 64.0f) {
                    fAlphaMultiplier = 0.0f;
                }
                circleImage.setRGB(i, j, new Color(1.0f, 1.0f, 1.0f, fAlphaMultiplier).getRGB());
                ++j;
            }
            ++i;
        }
        try {
            if (texture == null && Display.isCreated()) {
                texture = BufferedImageUtil.getTexture("enemy", circleImage);
            }
        }
        catch (IOException e) {
            System.err.println("Could not load the specified texture.");
            e.printStackTrace();
        }
    }

    public static void drawRadiance(float radius, int bandNum, float x, float y, float fRed, float fGreen, float fBlue, float ageAlpha) {
        if (texture != null) {
            GL11.glBegin(7);
            float fScaleSize = radius / 64.0f * 1.05f;
            float fHalfTextureWidth = (float)texture.getTextureWidth() * fScaleSize / 2.0f;
            float fHalfTextureHeight = (float)texture.getTextureHeight() * fScaleSize / 2.0f;
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex2f(x - fHalfTextureWidth, y - fHalfTextureHeight);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex2f(x + fHalfTextureWidth, y - fHalfTextureHeight);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex2f(x + fHalfTextureWidth, y + fHalfTextureHeight);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex2f(x - fHalfTextureWidth, y + fHalfTextureHeight);
            GL11.glEnd();
        }
    }

    public static void drawHueHalo(PlayerModel p, GameControl gameControl) {
        float y;
        float x;
        GL11.glPushMatrix();
        GL11.glTranslatef(PlayerModel.x, PlayerModel.y, 0.0f);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 1);
        GL11.glBegin(6);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.1f);
        GL11.glVertex2f(0.0f, 0.0f);
        float increment = 0.05235988f;
        float t = 0.0f;
        float radius = Constants.haloRadius;
        int i = 0;
        while (i <= 120) {
            float[] color = StaticDrawer.getColorValues(i, gameControl.getSaturation(), false);
            GL11.glColor4f(color[0], color[1], color[2], Constants.haloAlpha);
            x = (float)((double)radius * Math.cos(t));
            y = (float)((double)radius * Math.sin(t));
            t += increment;
            GL11.glVertex2d(x, y);
            ++i;
        }
        GL11.glEnd();
        GL11.glDisable(3042);
        GL11.glBegin(6);
        increment = 0.31415927f;
        t = 0.0f;
        GL11.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
        i = 0;
        while (i <= 20) {
            x = (float)((double)(2.0f + p.getCurrentRadius()) * Math.cos(t));
            y = (float)((double)(2.0f + p.getCurrentRadius()) * Math.sin(t));
            t += increment;
            GL11.glVertex2d(x, y);
            ++i;
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void drawProgressBar(int iSongLength, long currentTime, GameControl gameControl) {
        int i;
        float scale = 1.0f;
        if (Constants.progressAsVisualizer) {
            float largest = 0.0f;
            i = 0;
            while (i < gameControl.getSoundController().getFftLog().avgSize()) {
                largest = gameControl.getSoundController().getFftLog().getAvg(i) > largest ? gameControl.getSoundController().getFftLog().getAvg(i) : largest;
                ++i;
            }
            if (largest > Constants.progressMaxHeight) {
                scale = Constants.progressMaxHeight / largest;
            }
        }
        GL11.glBegin(5);
        if (Constants.bBandsInProgressBar) {
            float visOffset = 0.0f;
            i = 0;
            while (i < ColorArrangement.iBandArray.length) {
                float[] fColor = StaticDrawer.getColorValues(ColorArrangement.iBandArray[i], ColorArrangement.fSaturationArray[i], true);
                if (ColorArrangement.iBandArray[i] == 0) {
                    fColor[0] = 0.0f;
                    fColor[1] = 0.0f;
                    fColor[2] = 0.0f;
                }
                GL11.glColor4f(fColor[0], fColor[1], fColor[2], 0.0f);
                if (i <= ColorArrangement.currentPosition && Constants.progressAsVisualizer) {
                    int map = (int)((float)i / (float)ColorArrangement.currentPosition * (float)(gameControl.getSoundController().getFftLog().avgSize() - 1));
                    visOffset = gameControl.getSoundController().getFftLog().getAvg(map);
                    if ((visOffset *= scale) < 1.0f) {
                        visOffset = 1.0f;
                    }
                } else {
                    visOffset = Constants.progressAsVisualizer ? 1.0f : 10.0f;
                }
                GL11.glVertex2d(i, Constants.VIEW_HEIGHT);
                GL11.glVertex2d(i, Constants.VIEW_HEIGHT - 5);
                GL11.glVertex2d(i, (float)(Constants.VIEW_HEIGHT - 5) - visOffset);
                ++i;
            }
        } else {
            float fSpectrumPercent = 0.0f;
            long timeSinceStart = currentTime;
            float fPercentFromStart = (float)timeSinceStart / (float)iSongLength;
            int i2 = 0;
            while (i2 < Constants.VIEW_WIDTH) {
                fSpectrumPercent = (float)i2 / (float)Constants.VIEW_WIDTH;
                float[] fColor = StaticDrawer.getColorValues(fSpectrumPercent * 120.0f, gameControl.getSaturation(), false);
                GL11.glColor4f(fColor[0], fColor[1], fColor[2], 0.0f);
                int j = 0;
                while (j < 10) {
                    GL11.glVertex2d(i2, Constants.VIEW_HEIGHT - j);
                    ++j;
                }
                ++i2;
            }
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
            int iTriangleSize = 8;
            int j = 0;
            while (j <= iTriangleSize) {
                int i3 = 0;
                while (i3 < j) {
                    GL11.glVertex2d((float)Constants.VIEW_WIDTH * fPercentFromStart + (float)i3, Constants.VIEW_HEIGHT - 10 - j);
                    GL11.glVertex2d((float)Constants.VIEW_WIDTH * fPercentFromStart - (float)i3, Constants.VIEW_HEIGHT - 10 - j);
                    ++i3;
                }
                ++j;
            }
            int i4 = 0;
            while (i4 < 10) {
                GL11.glVertex2d((float)Constants.VIEW_WIDTH * fPercentFromStart, Constants.VIEW_HEIGHT - 10 + i4);
                ++i4;
            }
        }
        GL11.glEnd();
    }

    public static void playerVisualizer(PlayerModel p, SoundControl s, EnemyControl e, GameControl gameControl) {
        float t;
        GL11.glPushMatrix();
        GL11.glTranslatef(p.getPosition()[0], p.getPosition()[1], 0.0f);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 1);
        GL11.glColor4d(1.0, 1.0, 1.0, 0.2);
        GL11.glPolygonMode(1028, 6914);
        float w = (float)(Math.PI * 6 / (double)s.getFftLog().avgSize());
        float f = t = Constants.rotateVisualizer ? e.computeDirectionAngle() : 0.0f;
        if (!Constants.drawVisAsHueHalo) {
            GL11.glColor4f(p.getPlayerColor()[0], p.getPlayerColor()[1], p.getPlayerColor()[2], Constants.visualizerAlpha);
        }
        if (Constants.drawVis_Fan) {
            GL11.glBegin(6);
            int i = 0;
            while (i < s.getFftLog().avgSize()) {
                if (Constants.drawVisAsHueHalo) {
                    float percent360 = (float)((double)t % (Math.PI * 2) / (Math.PI * 2));
                    float[] colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation(), false);
                    GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                }
                float x2 = (float)((double)(p.getCurrentRadius() + 2.0f + s.getFftLog().getAvg(i)) * Math.cos(t));
                float y2 = (float)((double)(p.getCurrentRadius() + 2.0f + s.getFftLog().getAvg(i)) * Math.sin(t));
                GL11.glVertex2d(x2, y2);
                t += w;
                ++i;
            }
            GL11.glEnd();
        } else if (Constants.drawVis_BlocksSquare) {
            float mod = (float)s.getFftLog().avgSize() / 4.0f;
            int i = 0;
            while (i < s.getFftLog().avgSize()) {
                if (i % 2 == 0) {
                    float rotate;
                    float iScale = (float)i * 4.0f / 4.0f;
                    GL11.glPushMatrix();
                    if (Constants.drawVisAsHueHalo && i % 3 == 0) {
                        float percent360 = (float)i / (float)s.getFftLog().avgSize();
                        float[] colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation(), false);
                        GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                    }
                    if ((rotate = (float)((int)(iScale / mod))) == 0.0f) {
                        GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
                    } else if (rotate == 2.0f) {
                        GL11.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
                    } else if (rotate == 3.0f) {
                        GL11.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
                    }
                    GL11.glTranslatef(iScale - rotate * mod - (float)s.getFftLog().avgSize() / 8.0f, (float)(-s.getFftLog().avgSize()) / 8.0f, 0.0f);
                    GL11.glBegin(5);
                    float x1 = 0.0f;
                    float y1 = 0.0f;
                    float y2 = -s.getFftLog().getAvg(i);
                    GL11.glVertex2d(x1, y1);
                    GL11.glVertex2d(x1, y2);
                    GL11.glVertex2d(x1 += 2.0f, y1);
                    GL11.glVertex2d(x1, y2);
                    GL11.glEnd();
                    GL11.glPopMatrix();
                }
                ++i;
            }
        } else if (Constants.drawVis_BlocksRad) {
            w = (float)(Math.PI * 2 / (double)s.getFftLog().avgSize());
            t = (float)Math.PI;
            int i = 0;
            while (i < s.getFftLog().avgSize()) {
                if (i % 3 == 0) {
                    if (Constants.drawVisAsHueHalo) {
                        float percent360 = (float)((double)t % (Math.PI * 2) / (Math.PI * 2));
                        float[] colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation(), false);
                        GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                    }
                    GL11.glBegin(6);
                    float x2 = (float)((double)(p.getCurrentRadius() + 2.0f + s.getFftLog().getAvg(i)) * Math.cos(t));
                    float y2 = (float)((double)(p.getCurrentRadius() + 2.0f + s.getFftLog().getAvg(i)) * Math.sin(t));
                    float x1 = (float)((double)(p.getCurrentRadius() + 2.0f + s.getFftLog().getAvg(i)) * Math.cos(t + w * 3.0f));
                    float y1 = (float)((double)(p.getCurrentRadius() + 2.0f + s.getFftLog().getAvg(i)) * Math.sin(t + w * 3.0f));
                    GL11.glVertex2f(x1, y1);
                    GL11.glVertex2f(x2, y2);
                    GL11.glVertex2f(0.0f, 0.0f);
                    GL11.glEnd();
                }
                t += w;
                ++i;
            }
        } else if (Constants.drawVis_ScreenFan) {
            GL11.glBlendFunc(770, 771);
            GL11.glBegin(6);
            float[] colors = new float[]{1.0f, 1.0f, 1.0f};
            GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha / 20.0f);
            GL11.glVertex2f(0.0f, 0.0f);
            int i = 0;
            while (i < s.getFftLog().avgSize()) {
                float percent360 = (float)i / (float)s.getFftLog().avgSize();
                if (Constants.drawVisAsHueHalo) {
                    percent360 = (float)i / (float)s.getFftLog().avgSize();
                    colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation(), false);
                    GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                }
                float x1 = (float)(((double)percent360 - 0.5) * (double)Constants.VIEW_WIDTH);
                float y1 = s.getFftLog().getAvg(i) * 2.0f;
                GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                GL11.glVertex2d(x1, y1);
                GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha / 100.0f);
                GL11.glVertex2d(x1, 0.0);
                GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                GL11.glVertex2d(x1, -y1);
                t += w;
                ++i;
            }
            GL11.glEnd();
        } else if (Constants.drawVis_ScreenBlocks) {
            GL11.glPushMatrix();
            float inc = 1.0f / (float)s.getFftLog().avgSize() * (float)Constants.VIEW_WIDTH;
            GL11.glTranslatef(inc * 3.0f, 0.0f, 0.0f);
            float[] colors = new float[]{1.0f, 1.0f, 1.0f};
            int i = 0;
            while (i < s.getFftLog().avgSize()) {
                float percent360 = (float)i / (float)s.getFftLog().avgSize();
                if (Constants.drawVisAsHueHalo && i % 2 == 0) {
                    percent360 = (float)i / (float)s.getFftLog().avgSize();
                    colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation() + 1.0f, false);
                    GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                }
                GL11.glBegin(5);
                float x1 = (float)(((double)percent360 - 0.5) * (double)Constants.VIEW_WIDTH);
                float y1 = s.getFftLog().getAvg(i);
                GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                GL11.glVertex2d(x1, y1);
                GL11.glVertex2d(x1 + inc, y1);
                GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                GL11.glVertex2d(x1, 0.0);
                GL11.glVertex2d(x1 + inc, 0.0);
                GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                GL11.glVertex2d(x1, -y1);
                GL11.glVertex2d(x1 + inc, -y1);
                GL11.glEnd();
                t += w;
                ++i;
            }
            GL11.glPopMatrix();
        } else if (Constants.drawVis_RadialBeat) {
            float radius = Constants.VIEW_HEIGHT < Constants.VIEW_WIDTH ? Constants.VIEW_WIDTH / 2 : Constants.VIEW_HEIGHT / 2;
            float[] colors = new float[]{1.0f, 1.0f, 1.0f};
            int i = 0;
            while (i < s.getFftLog().avgSize()) {
                if (i % 2 == 0) {
                    if (Constants.drawVisAsHueHalo) {
                        float percent360 = (float)i / (float)s.getFftLog().avgSize();
                        colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation(), false);
                        GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                    }
                    float wid = s.getFftLog().getAvg(i) / 10.0f > 40.0f ? 40.0f : s.getFftLog().getAvg(i) / 10.0f;
                    GL11.glLineWidth(wid);
                    if (GL11.glGetInteger(2849) > 1) {
                        GL11.glBegin(3);
                        int j = 0;
                        while (j <= s.getFftLog().avgSize() - i + 10) {
                            t = (float)(Math.PI * 2 * (double)j / (double)(s.getFftLog().avgSize() - i + 10));
                            float x1 = (float)((double)(radius * (float)(s.getFftLog().avgSize() - i) / (float)s.getFftLog().avgSize()) * Math.cos(t));
                            float y1 = (float)((double)(radius * (float)(s.getFftLog().avgSize() - i) / (float)s.getFftLog().avgSize()) * Math.sin(t));
                            GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                            GL11.glVertex2f(x1, y1);
                            ++j;
                        }
                        GL11.glEnd();
                    }
                    GL11.glLineWidth(1.0f);
                }
                ++i;
            }
            GL11.glEnd();
        } else if (Constants.drawVis_RadialBeat2) {
            float radius = Constants.VIEW_HEIGHT < Constants.VIEW_WIDTH ? Constants.VIEW_WIDTH / 2 : Constants.VIEW_HEIGHT / 2;
            float[] colors = new float[]{1.0f, 1.0f, 1.0f};
            int i = 0;
            while (i < s.getFftLog().avgSize()) {
                if (i % 1 == 0) {
                    if (Constants.drawVisAsHueHalo) {
                        float percent360 = (float)i / (float)s.getFftLog().avgSize();
                        colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation() + 1.0f, false);
                        GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                    }
                    GL11.glBegin(3);
                    int j = 0;
                    while (j <= s.getFftLog().avgSize() - i + 10) {
                        t = (float)((double)s.getFftLog().getAvg(i) * Math.PI * (double)j / (double)(s.getFftLog().avgSize() - i + 10));
                        float x1 = (float)((double)(radius * (float)(s.getFftLog().avgSize() - i) / (float)s.getFftLog().avgSize()) * Math.cos(t));
                        float y1 = (float)((double)(radius * (float)(s.getFftLog().avgSize() - i) / (float)s.getFftLog().avgSize()) * Math.sin(t));
                        GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                        GL11.glVertex2f(x1, y1);
                        ++j;
                    }
                    GL11.glEnd();
                }
                ++i;
            }
            GL11.glEnd();
        } else if (Constants.drawVis_ScreenBlocks2) {
            GL11.glPushMatrix();
            float inc = 1.0f / (float)s.getFftLog().avgSize() * (float)Constants.VIEW_WIDTH / 2.0f;
            GL11.glTranslatef(-Constants.VIEW_WIDTH / 4, 0.0f, 0.0f);
            float[] colors = new float[]{1.0f, 1.0f, 1.0f};
            int i = 0;
            while (i < s.getFftLog().avgSize()) {
                float percent360 = (float)i / (float)s.getFftLog().avgSize();
                if (Constants.drawVisAsHueHalo && i % 2 == 0) {
                    percent360 = (float)i / (float)s.getFftLog().avgSize();
                    colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation(), false);
                    GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                }
                GL11.glBegin(5);
                float x1 = (float)(((double)percent360 - 0.5) * (double)Constants.VIEW_WIDTH / 2.0);
                float y1 = s.getFftLog().getAvg(i) * 2.0f;
                GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                GL11.glVertex2d(x1, y1);
                GL11.glVertex2d(x1 + inc, y1);
                GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                GL11.glVertex2d(x1, 0.0);
                GL11.glVertex2d(x1 + inc, 0.0);
                GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                GL11.glVertex2d(x1, -y1);
                GL11.glVertex2d(x1 + inc, -y1);
                GL11.glEnd();
                GL11.glBegin(5);
                x1 = (float)(Constants.VIEW_WIDTH * 3 / 4) - percent360 * (float)Constants.VIEW_WIDTH / 2.0f;
                y1 = s.getFftLog().getAvg(i) * 2.0f;
                GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                GL11.glVertex2d(x1, y1);
                GL11.glVertex2d(x1 - inc, y1);
                GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                GL11.glVertex2d(x1, 0.0);
                GL11.glVertex2d(x1 - inc, 0.0);
                GL11.glColor4f(colors[0], colors[1], colors[2], 0.0f);
                GL11.glVertex2d(x1, -y1);
                GL11.glVertex2d(x1 - inc, -y1);
                GL11.glEnd();
                ++i;
            }
            GL11.glPopMatrix();
        } else if (Constants.drawVis_Lines) {
            GL11.glPushMatrix();
            float off = s.getFftLog().getAvg(s.getFftLog().avgSize() / 2);
            GL11.glTranslatef(-Constants.VIEW_WIDTH / 2, off, 0.0f);
            float wid = (float)Constants.VIEW_WIDTH / (float)(s.getFftLog().avgSize() - 1);
            int numLines = 10;
            int i = 0;
            while (i < s.getFftLog().avgSize() - 1) {
                if (Constants.drawVisAsHueHalo && i % 3 == 0) {
                    float percent360 = (float)i / (float)s.getFftLog().avgSize();
                    float[] colors = StaticDrawer.getColorValues(percent360 * 120.0f, gameControl.getSaturation(), false);
                    GL11.glColor4f(colors[0], colors[1], colors[2], Constants.visualizerAlpha);
                }
                float x1 = (float)i * wid;
                float y1 = -s.getFftLog().getAvg(i);
                float x2 = (float)(i + 1) * wid;
                float y2 = -s.getFftLog().getAvg(i + 1);
                int j = 0;
                while (j < numLines) {
                    GL11.glBegin(3);
                    GL11.glVertex2f(x1, y1 + (float)((j - numLines / 2) * 10));
                    GL11.glVertex2f(x2, y2 + (float)((j - numLines / 2) * 10));
                    GL11.glEnd();
                    ++j;
                }
                ++i;
            }
            GL11.glPopMatrix();
        }
        GL11.glDisable(3042);
        GL11.glPopMatrix();
    }

    public static void drawEnemyVisualizer(EnemyModel e, GameControl g) {
        GL11.glEnable(3042);
        float[] color = e.geteCol();
        if (e.radius < e.visRadius) {
            float satScale = 1.0f;
            satScale = g.getSaturation() > 0.1f ? e.visRadius * g.getSaturation() / 5.0f : (g.getSaturation() > 0.7f ? e.visRadius * g.getSaturation() / 3.0f : 7.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef(e.x, e.y, 0.0f);
            float t = 0.0f;
            float inc = (float)(Math.PI * 2 / (double)(e.getfPreviousRadius() + 3.0f));
            GL11.glBegin(5);
            int i = 0;
            while ((float)i <= e.getfPreviousRadius() + 3.0f) {
                float x = (float)(Math.cos(t) * (double)(satScale + e.getfPreviousRadius()));
                float y = (float)(Math.sin(t) * (double)(satScale + e.getfPreviousRadius()));
                GL11.glColor4f(color[0], color[1], color[2], 0.0f);
                GL11.glVertex2f(x, y);
                x = (float)(Math.cos(t) * (double)e.getfPreviousRadius());
                y = (float)(Math.sin(t) * (double)e.getfPreviousRadius());
                GL11.glColor4f(color[0], color[1], color[2], Constants.visualizerAlpha);
                GL11.glVertex2f(x, y);
                t += inc;
                ++i;
            }
            GL11.glEnd();
            GL11.glPopMatrix();
        }
        GL11.glDisable(3042);
    }

    public static void fade(float x, float y, float w, float h, float alpha) {
        GL11.glEnable(3042);
        GL11.glBegin(9);
        GL11.glColor4f(0.0f, 0.0f, 0.0f, alpha);
        GL11.glVertex2d(w + x, y);
        GL11.glVertex2d(w + x, h + y);
        GL11.glVertex2d(x, h + y);
        GL11.glVertex2d(x, y);
        GL11.glEnd();
        GL11.glDisable(3042);
    }
}

